<?php
require_once ("HTML/QuickForm.php");

// tworzenie obiektu nowego formularza
$form = new HTML_QuickForm('firstForm');

// dodajemy dwa pola tekstowe; tutaj mamy moliwo wprowadzania dowolnych modyfikacji
$form->addElement('text', 'name', 'Imi i Nazwisko:', array('size' => 50, 
'maxlength' => 255));
$form->addElement('text', 'email', 'Adres e-mail:', array('size' => 50, 
'maxlength' => 255));

// dodajemy przycisk zatwierdzajcy
$form->addElement('submit', null, 'Wylij');

// dodajemy dowolne reguy kontroli wprowadzonych danych
// w tym celu naley posuy si metod
// addRule('kontrolowane_pole', 'ewentualny komunikat o bdzie', 'rodzaj kontroli',
$form->addRule('name', 'Nie podano nazwiska', 'required', null, 'client');
$form->addRule('email', 'Nie podano adresu e-mail', 'required', null, 'client');
$form->addRule('email', 'Nieprawidowy format adresu e-mail', 'email', null, 'client');

// przeprowadzony kontrole, aby upewni si, e uytkownik
// poprawnie wprowadzi dane. Jeeli tak, to wszystkie elementy
// formularza umieszczamy w tablicy. W ramach tego przykadu
// zawarto tablicy po prostu wypiszemy.
if ($form->validate()) {
    $elements=$form->exportValues();
    print_r ($elements);
    exit;
}

// wywietlenie formularza
$form->display();
?>
